/****** Object:  Schema [LL]    Script Date: 17.02.2024 20:27:25 ******/
CREATE SCHEMA [LL]
GO
/****** Object:  Schema [T2]    Script Date: 17.02.2024 20:27:25 ******/
CREATE SCHEMA [T2]
GO
/****** Object:  UserDefinedFunction [dbo].[fnIsNullOrEmpty]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Checks whether the passed value is either an empty string or NULL.
-- --------------------------------------------------------------------------------
-- Parameters :
--   @p_Value AS nvarchar(max)
--      Input string to be checked.
--   @p_Trim  AS bit
--      Specifies, whether the input string is to be trimmed prior to checking the
--      input string for an empty string or NULL.
-- --------------------------------------------------------------------------------
-- Return Value:
--    Is NULL -or- empty = 1
--    ELSE               = 0
-- --------------------------------------------------------------------------------
CREATE FUNCTION [dbo].[fnIsNullOrEmpty] (@p_Value AS nvarchar(max), @p_Trim AS bit) RETURNS bit
AS
BEGIN
   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   DECLARE @returnValue       AS bit;

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   SET @returnValue = 0;

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   IF (@p_Value IS NULL)
      SET @returnValue = 1;
   ELSE
      BEGIN
         IF @p_Trim = 1
            BEGIN
               SET @p_Value = TRIM(@p_Value);
            END;

         IF DATALENGTH(@p_Value) = 0
            BEGIN
               SET @returnValue = 1;
            END
         ELSE
            BEGIN
               SET @returnValue = 0;
            END;
      END;
   RETURN @returnValue;
END;
-- [dbo].[fnIsNullOrEmpty]

-- SELECT [dbo].[fnIsNullOrEmpty] (NULL  , 0); -- expected result: 1
-- SELECT [dbo].[fnIsNullOrEmpty] (NULL  , 1); -- expected result: 1
-- SELECT [dbo].[fnIsNullOrEmpty] (N''   , 0); -- expected result: 1
-- SELECT [dbo].[fnIsNullOrEmpty] (N''   , 1); -- expected result: 1
-- SELECT [dbo].[fnIsNullOrEmpty] (N' '  , 0); -- expected result: 0
-- SELECT [dbo].[fnIsNullOrEmpty] (N' '  , 1); -- expected result: 1
-- SELECT [dbo].[fnIsNullOrEmpty] (N'  ' , 0); -- expected result: 0
-- SELECT [dbo].[fnIsNullOrEmpty] (N'  ' , 1); -- expected result: 1
-- SELECT [dbo].[fnIsNullOrEmpty] (N' X ', 0); -- expected result: 0
-- SELECT [dbo].[fnIsNullOrEmpty] (N' X ', 1); -- expected result: 0
GO
/****** Object:  StoredProcedure [dbo].[spRaiseError]    Script Date: 17.02.2024 20:29:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Fires an execption with the passed parameters, severity and state.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_message               AS nvarchar(max)
--       Error messsage
--    @p_procedure             AS nvarchar(128)
--       Object name of the calling object.
--    @p_severity              AS int = 16
--       Severity of the error
--    @p_state                 AS int = 1
--       State of the error
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[spRaiseError]
    @p_message               AS nvarchar(max)
   ,@p_procedure             AS nvarchar(128)
   ,@p_severity              AS int          = 16
   ,@p_state                 AS int          = 1
AS
BEGIN
   SET NOCOUNT ON;

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   IF @p_message IS NULL
      BEGIN
         RAISERROR (N'An error occured in stored procedure ''%s''.', @p_severity, @p_state, @p_procedure);
      END
   ELSE
      BEGIN
         RAISERROR  (N'An error occured in stored procedure ''%s'': %s', @p_severity, @p_state, @p_procedure, @p_message);
      END;
END
--[dbo].[spRaiseError]
/****** Object:  StoredProcedure [LL].[spInsertComponent]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Inserts a row in table [LL].[Component] with
--    [state]   = 'processing'
--    [success] = 0
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_executionId          AS int
--       Execution Id of the current execution.
--    @p_componentId          AS int OUT
--       Returns the Id of the new row in [LL].[Component].
--    @p_source               AS nvarchar(5)
--       Type of the calling source system (SSIS, T-SQL, ...).
--    @p_component            AS nvarchar(128)
--       Name of the calling SSIS-Package.
--    @p_version              AS int = NULL
--       Version number of the calling SSIS package.
--       This parameter applies only to SSIS.
--    @p_entity               AS nvarchar(128) = NULL
--       Entity name the log entry refers to.
--    @p_step                 AS nvarchar(max)
--       Description of the task in the calling object that will be logged.
--    @p_description          AS nvarchar(max) = NULL
--       Additional description of the task in the calling object that will be logged.
--    @p_fileId               AS int = NULL
--       Foreign Key to [LL].[FileList].[Id]
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spInsertComponent]
    @p_executionId           AS int
   ,@p_componentId           AS int OUT
   ,@p_source                AS nvarchar(5)
   ,@p_component             AS nvarchar(128)
   ,@p_version               AS int           = NULL
   ,@p_entity                AS nvarchar(128) = NULL
   ,@p_step                  AS nvarchar(max)
   ,@p_description           AS nvarchar(max) = NULL
   ,@p_fileId                AS int           = NULL
AS
BEGIN
   SET NOCOUNT ON;

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   DECLARE @component        AS nvarchar(128);
   DECLARE @table            AS table([Id] int);

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   SET @component = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);

      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      BEGIN
         -- --------------------------------------------------------------------------------
         -- Check @p_executionId
         -- --------------------------------------------------------------------------------
         IF (@p_executionId IS NULL)
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_ExecutionId'' is NULL.', @component;
               RETURN 0;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_source
         -- --------------------------------------------------------------------------------
         IF ([dbo].[fnIsNullOrEmpty](@p_source, 1) <> 0 )
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_source'' is either NULL or an empty string.', @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_component
         -- --------------------------------------------------------------------------------
         IF ([dbo].[fnIsNullOrEmpty](@p_component, 1) <> 0 )
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_component'' is either NULL or an empty string.', @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_step
         -- --------------------------------------------------------------------------------
         IF ([dbo].[fnIsNullOrEmpty](@p_step, 1) <> 0)
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_step'' is either NULL or an empty string.', @component;
               RETURN 1;
            END;
      END;

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   INSERT INTO [LL].[Component]
   (
       [ExecutionId]
      ,[Source]
      ,[Component]
      ,[Version]
      ,[Entity]
      ,[Step]
      ,[Description]
      ,[FileId]
      ,[State]
      ,[Success]
   )
   OUTPUT Inserted.Id INTO @table
   VALUES
   (
       @p_executionId
      ,@p_source
      ,@p_component
      ,@p_version
      ,@p_entity
      ,@p_step
      ,@p_description
      ,@p_fileId
      ,'processing'
      ,0
   );

   SELECT @p_componentId = [Id] FROM @table;

   RETURN 0;
END;
-- [LL].[spInsertComponent]

-- DECLARE @ExecutionId  AS int;
-- DECLARE @ComponentId  AS int;
-- DECLARE @source       AS nvarchar(5);
-- DECLARE @component    AS nvarchar(128);
-- DECLARE @version AS int;
-- DECLARE @entity       AS nvarchar(128);
-- DECLARE @step         AS nvarchar(max);
-- DECLARE @description  AS nvarchar(max);
-- DECLARE @fileId       AS bigint;

-- SET @ExecutionId  = 1;
-- SET @source       = 'T-SQL';
-- SET @component    = 'test script';
-- SET @version = 123;
-- SET @entity       = '[LL].[spInsertComponent]';
-- SET @step         = '[LL].[spInsertComponent]';
-- SET @description  = 'none';
-- SET @fileId       = 456;

-- EXEC [LL].[spInsertComponent]
--     @p_executionId  = @ExecutionId
--    ,@p_componentId  = @ComponentId OUTPUT
--    ,@p_source       = @source
--    ,@p_component    = @component
--    ,@p_version = @version
--    ,@p_entity       = @entity
--    ,@p_step         = @step
--    ,@p_description  = @description
--    ,@p_fileId       = @fileId;

-- SELECT @ComponentId;
-- SELECT * FROM [LL].[Component] WHERE [ID] = @ComponentId;
GO
/****** Object:  StoredProcedure [LL].[spInsertError]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Inserts a row in table [LL].[Error].
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_executionId          AS int
--       Execution ID of the current execution
--    @p_componentId          AS int
--       Component ID the error message is related to.
--    @p_traceId              AS int
--       Trace ID the error message is related to.
--    @p_errorType            AS char(1)
--       Specifies the error type of the entry
--         I = Information
--         W = Warning
--         E = Error
--    @p_source               AS nvarchar(5)
--       Specifies the source that is responsible for the error log entry
--        'SSIS'
--        'T-SQL'
--    @p_component            AS nvarchar(128)
--       Specifies either the SQL Procedure Name or an an SSIS Package Name
--    @p_task                 AS nvarchar(128)  = NULL
--       Task Name (SSIS specific)
--    @p_entity               AS nvarchar(128)
--       Name of the table that is involved in this procedure call.
--    @p_step                 AS nvarchar(max)
--       Describe the step, that invokes this procedure call.
--    @p_schema               AS nvarchar(128)  = NULL
--       Specifies the schema name of the table that contains the error.
--    @p_table                AS nvarchar(128)  = NULL
--       Specifies the table name of the table that contains the error.
--    @p_ID1Field             AS nvarchar(128)
--       Primary key 1 field name of the record the error is related to. The primary key field must
--       exist in the table that is specified in p_table.
--    @p_ID1Value             AS nvarchar(max)
--       Primary key 1 value of the record the error is related to.
--    @p_ID2Field             AS nvarchar(128)  = NULL
--       Primary key 2 field name of the record the error is related to. The primary key field must
--       exist in the table that is specified in p_table.
--    @p_ID2Value             AS nvarchar(max)  = NULL
--       Primary key 2 value of the record the error is related to.
--    @p_ID3Field             AS nvarchar(128)  = NULL
--       Primary key 3 field name of the record the error is related to. The primary key field must
--       exist in the table that is specified in p_table.
--    @p_ID3Value             AS nvarchar(max)  = NULL
--       Primary key 3 value of the record the error is related to.
--    @p_errorValue           AS nvarchar(max)  = NULL
--       Error value
--    @p_errorField           AS nvarchar(128)  = NULL
--       Field name of the field that contains the erroneous value
--    @p_errorFileName        AS nvarchar(128)  = NULL
--       File name of the file the error is related to
--    @p_errorNumber          AS int            = NULL
--       SQL Error number.
--    @p_errorDescription     AS nvarchar(max)  = NULL
--       SQL Error description.
--    @p_errorLine            AS int            = NULL
--       SQL Error line.
--    @p_errorState           AS nvarchar(max)  = NULL
--       SQL Error state.
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spInsertError]
    @p_executionId           AS int
   ,@p_componentId           AS int
   ,@p_traceId               AS int
   ,@p_errorType             AS char(1)
   ,@p_source                AS nvarchar(5)
   ,@p_component             AS nvarchar(128)
   ,@p_task                  AS nvarchar(128)  = NULL
   ,@p_entity                AS nvarchar(128)
   ,@p_step                  AS nvarchar(max)
   ,@p_schema                AS nvarchar(128)  = NULL
   ,@p_table                 AS nvarchar(128)  = NULL
   ,@p_ID1Field              AS nvarchar(128)
   ,@p_ID1Value              AS nvarchar(max)
   ,@p_ID2Field              AS nvarchar(128)  = NULL
   ,@p_ID2Value              AS nvarchar(max)  = NULL
   ,@p_ID3Field              AS nvarchar(128)  = NULL
   ,@p_ID3Value              AS nvarchar(max)  = NULL
   ,@p_errorValue            AS nvarchar(max)  = NULL
   ,@p_errorField            AS nvarchar(128)  = NULL
   ,@p_errorFileName         AS nvarchar(128)  = NULL
   ,@p_errorNumber           AS int            = NULL
   ,@p_errorDescription      AS nvarchar(max)  = NULL
   ,@p_errorLine             AS int            = NULL
   ,@p_errorState            AS nvarchar(max)  = NULL
AS
BEGIN
   SET NOCOUNT ON;

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   DECLARE @component        AS nvarchar(128);

   SET @component = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);

   -- --------------------------------------------------------------------------------
   -- Check parameters
   -- --------------------------------------------------------------------------------
   BEGIN
         -- --------------------------------------------------------------------------------
         -- Check @p_executionId
         -- --------------------------------------------------------------------------------
      IF (@p_executionId IS NULL )
         BEGIN
            EXEC [dbo].[spRaiseError] N'The parameter ''p_ExecutionId'' is NULL.', @p_component;
            RETURN 1;
         END;
         -- --------------------------------------------------------------------------------
         -- Check @p_component
         -- --------------------------------------------------------------------------------
      IF (@p_component IS NULL)
         BEGIN
            EXEC [dbo].[spRaiseError] N'The parameter ''p_component'' is NULL.', @component;
            RETURN 1;
         END;
         -- --------------------------------------------------------------------------------
         -- Check @p_errorType
         -- --------------------------------------------------------------------------------
      IF ([dbo].[fnIsNullOrEmpty](@p_errorType, 1) <> 0 )
         BEGIN
            EXEC [dbo].[spRaiseError] N'The parameter ''p_errortype'' is either NULL or an empty string.', @p_component;
            RETURN 1;
         END;
         -- --------------------------------------------------------------------------------
         -- Check @p_source
         -- --------------------------------------------------------------------------------
      IF ([dbo].[fnIsNullOrEmpty](@p_source, 1) <> 0)
         BEGIN
            EXEC [dbo].[spRaiseError] N'The parameter ''p_source'' is NULL.', @p_component;
            RETURN 1;
         END
      ELSE IF LEN(TRIM(@p_source)) > 5
         BEGIN
            EXEC [dbo].[spRaiseError] N'The parameter ''p_source'' is too long (max. 5 characters).', @p_component;
            RETURN 1;
         END;
   END;

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   SET @p_errorType = UPPER(@p_errorType);
   SET @p_source    = TRIM(@p_source);
   SET @p_component = LOWER(TRIM(@p_component));
   SET @p_table     = CASE WHEN @p_table IS NULL THEN '<System>' ELSE @p_table END;

   INSERT INTO [LL].[Error]
   (
       [ExecutionId]
      ,[ComponentId]
      ,[TraceId]
      ,[ErrorType]
      ,[Source]
      ,[Component]
      ,[TaskName]
      ,[Entity]
      ,[Step]
      ,[SchemaName]
      ,[TableName]
      ,[ID1Value]
      ,[ID1ColumnName]
      ,[ID2Value]
      ,[ID2ColumnName]
      ,[ID3Value]
      ,[ID3ColumnName]
      ,[ErrorValue]
      ,[ErrorColumnName]
      ,[FileName]
      ,[Description]
      ,[Number]
      ,[Line]
      ,[State]
      ,[CreatedBy]
      ,[CreatedOn]
   )
   VALUES
   (
       @p_executionId
      ,@p_componentId
      ,@p_traceId
      ,@p_errorType
      ,@p_source
      ,@p_component
      ,@p_task
      ,@p_entity
      ,@p_step
      ,@p_schema
      ,@p_table
      ,@p_ID1Value
      ,@p_ID1Field
      ,@p_ID2Value
      ,@p_ID2Field
      ,@p_ID3Value
      ,@p_ID3Field
      ,@p_errorValue
      ,@p_errorField
      ,@p_errorFileName
      ,@p_errorDescription
      ,@p_errorNumber
      ,@p_errorLine
      ,@p_errorState
      ,SYSTEM_USER
      ,GETUTCDATE()
   );

   RETURN 0;
END
-- [LL].[spInsertError]
GO
/****** Object:  StoredProcedure [LL].[spInsertErrorException]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Inserts a row in table [LL].[Error]. The procedure is used for 
--              logging an exception.
--
--              This procedure calls [LL].[spInsertError] and encapsulates the
--              following parameters:
--
--                @p_schema        = NULL
--                @p_table         = NULL
--                @p_errorType     = 'E'
--                @p_errorLine     = NULL
--                @p_errorState    = NULL
--                @p_errorValue    = NULL
--                @p_errorField    = NULL
--                @p_errorFileName = NULL
--                @p_ID1Field      = NULL
--                @p_ID1Value      = NULL
--                @p_ID2Field      = NULL
--                @p_ID2Value      = NULL
--                @p_ID3Field      = NULL
--                @p_ID3Value      = NULL
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_executionId          AS int
--       Execution ID of the current execution
--    @p_componentId          AS int
--       Component ID the error message is related to.
--    @p_traceId              AS int
--       Trace ID the error message is related to.
--    @p_source               AS nvarchar(5)
--       Specifies the source that is responsible for the error log entry
--        'SSIS'
--        'T-SQL'
--    @p_component            AS nvarchar(128)
--       System::PackageName (SSIS specific)
--    @p_task                 AS nvarchar(128)
--       Task Name (SSIS specific)
--    @p_entity               AS nvarchar(128)
--       Name of the table that is involved in this procedure call.
--    @p_step                 AS nvarchar(max)
--       Describe the step, that invokes this procedure call.
--    @p_errorNumber          AS int
--       SQL Error Code
--    @p_errorDescription     AS nvarchar(max)
--       SQL Error Description
--    @p_errorLine            AS int            = NULL
--       SQL Error line.
--    @p_errorState           AS nvarchar(max)  = NULL
--       SQL Error state.
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spInsertErrorException]
    @p_executionId           AS int
   ,@p_componentId           AS int
   ,@p_traceId               AS int
   ,@p_source                AS nvarchar(5)
   ,@p_component             AS nvarchar(128)
   ,@p_task                  AS nvarchar(128)
   ,@p_entity                AS nvarchar(128)
   ,@p_step                  AS nvarchar(128)
   ,@p_errorNumber           AS int
   ,@p_errorDescription      AS nvarchar(max)
   ,@p_errorLine             AS int
   ,@p_errorState            AS nvarchar(max)
AS
BEGIN
   SET NOCOUNT ON;

   EXECUTE [LL].[spInsertError]
       @p_executionId
      ,@p_componentId
      ,@p_traceId
      ,N'E'
      ,@p_source
      ,@p_component
      ,@p_task
      ,@p_entity
      ,@p_step
      ,NULL
      ,NULL
      ,NULL
      ,NULL
      ,NULL
      ,NULL
      ,NULL
      ,NULL
      ,NULL
      ,NULL
      ,NULL
      ,@p_errorNumber
      ,@p_errorDescription
      ,@p_errorLine
      ,@p_errorState
END;
-- [LL].[spInsertErrorException]
GO
/****** Object:  StoredProcedure [LL].[spInsertExecution]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Insert a row into the table [LL].[Execution] with
--                [state]   = 'processing'
--                [success] = 0
--              This procedure determines the time period for a possible delta-load
--              automatically.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_executionId          AS int OUT
--       Returns the Id of the new row in [LL].[Execution].
--    @p_process              AS nvarchar(max)
--       Name of the execution process.
--    @p_version              AS int
--       Optional: Version Number of the starting object
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spInsertExecution]
    @p_executionId           AS int OUT
   ,@p_process               AS nvarchar(max)
   ,@p_version               AS int
AS
BEGIN
   SET NOCOUNT ON;

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   DECLARE @component        AS nvarchar(128);
   DECLARE @start            AS datetime;
   DECLARE @tempid           AS int;
   DECLARE @message          AS nvarchar(max);
   DECLARE @table            AS table([Id] int);
   DECLARE @deltaStart       AS datetime;
   DECLARE @deltaEnd         AS datetime;

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   SET @component = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);
   SET @start     = GETUTCDATE();

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Get the Id and the time period for a Delta-Load the of the last successful
      -- execution
      -- --------------------------------------------------------------------------------
      SELECT TOP 1
          @tempid      = [Id]
         ,@deltaStart  = [DeltaStart]
         ,@deltaEnd    = [DeltaEnd]
      FROM
         [LL].[Execution]
      WHERE
             [Process] = 'process name'
         AND [Success] = 1;

      -- --------------------------------------------------------------------------------
      -- Set new time period
      -- --------------------------------------------------------------------------------
      IF @tempid IS NULL
         BEGIN
            SET @deltaStart = CAST('1753-01-01' AS datetime);
            SET @deltaEnd   = GETUTCDATE();
         END
      ELSE
         BEGIN
            SET @deltaStart = @deltaEnd;
            SET @deltaEnd   = GETUTCDATE();
         END;

      -- --------------------------------------------------------------------------------
      -- Insert execution log into Execution
      -- --------------------------------------------------------------------------------
      INSERT INTO [LL].[Execution]
      (
          [Process]
         ,[Start]
         ,[End]
         ,[DeltaStart]
         ,[DeltaEnd]
         ,[Version]
         ,[State]
         ,[Success]
      )
      OUTPUT Inserted.Id INTO @table
      VALUES
      (
          @p_process
         ,@start
         ,NULL
         ,@deltaStart
         ,@deltaEnd
         ,@p_version
         ,'processing'
         ,0
      )
      SELECT @p_executionId = [Id] FROM @table;

      RETURN 0;
   END TRY
   BEGIN CATCH
      THROW;
   END CATCH;
END
-- [LL].[spInsertExecution]

--DECLARE @ExecutionId   AS int;
--EXEC [LL].[spInsertExecution] @ExecutionId OUTPUT, 'process name', 123, N'2018-01-01', N'2018-02-01';
--SELECT * FROM [LL].[Execution];
GO
/****** Object:  StoredProcedure [LL].[spInsertTrace]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Inserts a row in table [LL].[Trace]
-- --------------------------------------------------------------------------------
-- Parameters
--    @p_executionId          AS int
--       Execution Id of the current execution
--    @p_componentId          AS int
--       Each procedure call gets a unique id that allows identifying all messages
--       that will be written by the procedure call
--    @p_traceId              AS int OUT
--       Returns the Id of the new row in [LL].[Trace]
--    @p_source               AS nvarchar(5)
--       Type of the calling source system (SSIS, T-SQL, ...)
--    @p_component            AS nvarchar(128)
--       Name of the calling SSIS-Package
--    @p_task                 AS nvarchar(128) = NULL
--       SSIS-Task name the log entry refers to.
--    @p_entity               AS nvarchar(128) = NULL
--       Entity name the log entry refers to.
--    @p_step                 AS nvarchar(max)
--       Description of the task in the calling object that will be logged
--    @p_description          AS nvarchar(max) = NULL
--       Additional description of the task in the calling object that will be
--       logged
--    @p_fileId               AS int = NULL
--       Foreign Key to [LL].[FileList].[Id]
--    @p_action               AS nvarchar(max) = NULL
--       Specifiy any action that will be logged by this procedure call like
--       Insert, Delete, Update, ...
--    @p_affectedRows         AS nvarchar(max) = NULL
--       Specifiy the number of rows/objects that were inserted, deleted, updated, ...
--    @p_state                AS nvarchar(100)
--       State of the current task (processing, success, error, warning)
--    @p_success              AS bit
--       Specifies whether the calling procedure succeded
--       0 = processing, warning, error
--       1 = success
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spInsertTrace]
    @p_executionId           AS int
   ,@p_componentId           AS int
   ,@p_traceId               AS int OUT
   ,@p_source                AS nvarchar(5)
   ,@p_component             AS nvarchar(128)
   ,@p_task                  AS nvarchar(128)
   ,@p_entity                AS nvarchar(128)
   ,@p_step                  AS nvarchar(max)
   ,@p_description           AS nvarchar(max)
   ,@p_fileId                AS bigint        = NULL
   ,@p_action                AS nvarchar(100) = NULL
   ,@p_affectedRows          AS int
   ,@p_state                 AS nvarchar(100)
   ,@p_success               AS bit
AS
BEGIN
   SET NOCOUNT ON;

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   DECLARE @component        AS nvarchar(128);
   DECLARE @table            AS table([Id] int);
   DECLARE @message          AS nvarchar(max);

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   SET @component = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      BEGIN
         -- --------------------------------------------------------------------------------
         -- Check @p_executionId
         -- --------------------------------------------------------------------------------
         IF (@p_executionId IS NULL)
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_ExecutionId'' is NULL.', @component;
               RETURN 0;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_componentId
         -- --------------------------------------------------------------------------------
         IF (@p_componentId IS NULL)
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_ComponentId'' is NULL.', @component;
               RETURN 0;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_source
         -- --------------------------------------------------------------------------------
         IF ([dbo].[fnIsNullOrEmpty](@p_source, 1) <> 0 )
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_source'' is either NULL or an empty string.', @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_component
         -- --------------------------------------------------------------------------------
         IF ([dbo].[fnIsNullOrEmpty](@p_component, 1) <> 0 )
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_component'' is either NULL or an empty string.', @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_step
         -- --------------------------------------------------------------------------------
         IF ([dbo].[fnIsNullOrEmpty](@p_step, 1) <> 0)
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_step'' is either NULL or an empty string.', @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_state
         -- --------------------------------------------------------------------------------
         IF ([dbo].[fnIsNullOrEmpty](@p_state, 1) <> 0)
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_state'' is either NULL or an empty string', @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_success
         -- --------------------------------------------------------------------------------
         IF @p_success IS NULL
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_success'' is either NULL.', @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check combination of @p_success and @p_state
         -- --------------------------------------------------------------------------------
         IF (@p_success = 0 AND @p_state IN ('success')) OR (@p_success = 1 AND @p_state IN ('processing', 'error'))
            BEGIN
               SET @message = CONCAT('Invalid state ''', @p_state, ''' for p_success = ''', CAST(@p_success AS nvarchar(100)),'''.');
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
      END;

      -- --------------------------------------------------------------------------------
      -- Insert trace into [LL].[Trace]
      -- --------------------------------------------------------------------------------
      INSERT INTO [LL].[Trace]
      (
          [ExecutionId]
         ,[ComponentId]
         ,[Source]
         ,[Component]
         ,[Task]
         ,[Entity]
         ,[Step]
         ,[Description]
         ,[FileId]
         ,[Action]
         ,[AffectedRows]
         ,[State]
         ,[Success]
      )
      OUTPUT Inserted.Id INTO @table
      VALUES
      (
          @p_executionId
         ,@p_componentId
         ,@p_source
         ,@p_component
         ,@p_task
         ,@p_entity
         ,@p_step
         ,CASE WHEN @p_description IS NULL OR DATALENGTH(@p_description) = 0  THEN NULL ELSE @p_description END
         ,@p_fileId
         ,@p_action
         ,@p_affectedRows
         ,@p_state
         ,@p_success
      );

      SELECT @p_traceId = [Id] FROM @table;

      RETURN 0;
   END TRY
   BEGIN CATCH
      THROW;
   END CATCH;
END;
-- [LL].[spInsertTrace]

-- DECLARE @ExecutionId  AS int;
-- DECLARE @ComponentId  AS int;
-- DECLARE @traceId      AS int;
-- DECLARE @source       AS nvarchar(5);
-- DECLARE @component    AS nvarchar(128);
-- DECLARE @entity       AS nvarchar(128);
-- DECLARE @step         AS nvarchar(max);
-- DECLARE @description  AS nvarchar(max);
-- DECLARE @fileId       AS bigint
-- DECLARE @action       AS nvarchar(100) = NULL
-- DECLARE @affectedRows AS int
-- DECLARE @state        AS nvarchar(100);
-- DECLARE @success      AS bit;
--
-- SET @ExecutionId  = 1;
-- SET @ComponentId  = 1;
-- SET @source       = 'T-SQL';
-- SET @component    = 'test script';
-- SET @entity       = '[LL].[spInsertTrace]';
-- SET @step         = '[LL].[spInsertTrace]';
-- SET @description  = 'none';
-- SET @fileId       = 456;
-- SET @action       = 'Insert';
-- SET @affectedRows = 55;
-- SET @state        = 'processing';
-- SET @success      = 0;
--
-- EXEC [LL].[spInsertTrace]
--     @p_executionId  = @ExecutionId
--    ,@p_componentId  = @ComponentId
--    ,@p_traceId      = @traceId OUTPUT
--    ,@p_source       = @source
--    ,@p_component    = @component
--    ,@p_entity       = @entity
--    ,@p_step         = @step
--    ,@p_description  = @description
--    ,@p_fileId       = @fileId
--    ,@p_action       = @action
--    ,@p_affectedRows = @affectedRows
--    ,@p_state        = @state
--    ,@p_success      = @success;
--
-- SELECT @traceId;
-- SELECT * FROM [LL].[Trace] WHERE [Id] = @traceId;
GO
/****** Object:  StoredProcedure [LL].[spUpdateComponent]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Updates the fields [State] and [Success] in [LL].[Component] for
--              the row with [ID] = @p_componentId.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_componentId          AS int
--       ID of the row in [LL].[Component], that is to be updated.
--    @p_description          AS nvarchar(max)
--       Additional description of the task in the calling object that will be logged
--    @p_state                AS nvarchar(100)
--       State of the current task (processing, success, error, warning)
--    @p_success              AS bit
--       Specifies the success state of the execution
--       0 = @p_state > processing, warning, error
--       1 = @p_state > success, warning
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spUpdateComponent]
    @p_componentId           AS int
   ,@p_description           AS nvarchar(max)
   ,@p_state                 AS nvarchar(100)
   ,@p_success               AS bit
AS
BEGIN
   SET NOCOUNT ON;

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   DECLARE @component        AS nvarchar(128);
   DECLARE @tempuid          AS int;
   DECLARE @message          AS nvarchar(max);

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   SET @component = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      BEGIN
         IF (@p_componentId IS NULL)
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_ComponentId'' is NULL.', @component;
               RETURN 1;
            END;
         IF ([dbo].[fnIsNullOrEmpty](@p_state, 1) <> 0 )
            BEGIN
               SET @message = N'The parameter ''p_state'' is NULL or an empty string.';
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
         IF (@p_success IS NULL)
            BEGIN
               SET @message = N'The parameter ''p_success'' is NULL.';
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
         IF (@p_success = 0 AND @p_state IN (N'success')) OR (@p_success = 1 AND @p_state IN (N'processing', N'error'))
            BEGIN
               SET @message = CONCAT(N'Invalid state ''', @p_state, N''' for p_success = ''', CAST(@p_success AS nvarchar(100)), N'''.');
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check whether an Component log does exist in [LL].[Component] with
         -- [ID] = @p_componentId
         -- --------------------------------------------------------------------------------
         SELECT
             @tempuid = [Id]
         FROM
            [LL].[Component]
         WHERE
            [Id] = @p_componentId;

         IF (@tempuid IS NULL)
            BEGIN
               SET @message = 'A record with [Id] = ''' + CAST(@p_componentId AS nvarchar(max)) + ''' could not be found.';
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
      END;

      -- --------------------------------------------------------------------------------
      -- Update trace log in [LL].[Component]
      -- --------------------------------------------------------------------------------
      UPDATE [LL].[Component]
         SET
             [State]       = @p_state
            ,[Description] = CASE WHEN @p_description IS NULL THEN [Description] ELSE @p_description END
            ,[Success]     = @p_success
      WHERE
         [ID] = @p_componentId;

      RETURN 0;
   END TRY
   BEGIN CATCH
      THROW;
   END CATCH;
END;
-- [LL].[spUpdateComponent]

-- EXEC [LL].[spUpdateComponent] 1, N'process successfully finished', N'success', 1;
GO
/****** Object:  StoredProcedure [LL].[spUpdateComponentError]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Updates [LL].[Component] with [State] = 'error' and [Success] = '0'.
--              Designed for usage in SSIS.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_componentId          AS int
--       ID of the row in [LL].[Component], that is to be updated.
--    @p_description          AS nvarchar(max)
--       Additional description of the task in the calling object that will be logged
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spUpdateComponentError]
   @p_componentId            AS int
  ,@p_description            AS nvarchar(max)
AS
BEGIN
   SET NOCOUNT ON;

   EXEC [LL].[spUpdateComponent]
       @p_componentId
      ,@p_description
      ,'error'
      ,0;
END;
-- [LL].[spUpdateComponentError]

-- EXEC [LL].[spUpdateComponentError] 1, N'process finished with errors';
GO
/****** Object:  StoredProcedure [LL].[spUpdateComponentSuccess]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Updates [LL].[Component] with [State] = 'success' and [Success] = '1'.
--              Designed for usage in SSIS.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_componentId          AS int
--       ID of the row in [LL].[Component], that is to be updated.
--    @p_description          AS nvarchar(max)
--       Additional description of the task in the calling object that will be logged
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spUpdateComponentSuccess]
   @p_componentId            AS int
  ,@p_description            AS nvarchar(max)
AS
BEGIN
   SET NOCOUNT ON;

   EXEC [LL].[spUpdateComponent]
       @p_componentId
      ,@p_description
      ,'success'
      ,1;
END;
-- [LL].[spUpdateComponentSuccess]

-- EXEC [LL].[spUpdateComponentSuccess] 1, N'process successfully finished';
GO
/****** Object:  StoredProcedure [LL].[spUpdateComponentWarning]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Updates [LL].[Component] with [State] = 'warning' and [Success] = '1'.
--              Designed for usage in SSIS.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_componentId          AS int
--       ID of the row in [LL].[Component], that is to be updated.
--    @p_description          AS nvarchar(max)
--       Additional description of the task in the calling object that will be logged
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spUpdateComponentWarning]
   @p_componentId            AS int
  ,@p_description            AS nvarchar(max)
AS
BEGIN
   SET NOCOUNT ON;

   EXEC [LL].[spUpdateComponent]
       @p_componentId
      ,@p_description
      ,'warning'
      ,1;
END;
-- [LL].[spUpdateComponentWarning]

-- EXEC [LL].[spUpdateComponentWarning] 1, N'process finished with warnings';
GO
/****** Object:  StoredProcedure [LL].[spUpdateExecution]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Updates the fields [End], State], [Success]  in
--              the table [LL].[Execution] with [ID] = @p_executionId.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_executionId          AS int
--       ID of the row in [Execution] to be updated.
--    @p_state                AS nvarchar(128)
--       State of the current task (processing, success, error, warning)
--    @p_success              AS bit
--       Specifies the success state of the execution
--       0 = @p_state > processing, warning, error
--       1 = @p_state > success, warning
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spUpdateExecution]
    @p_executionId           AS int
   ,@p_state                 AS nvarchar(128)
   ,@p_success               AS bit
AS
BEGIN
   SET NOCOUNT ON;

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   DECLARE @component                  AS nvarchar(128);
   DECLARE @tempuid                    AS int;
   DECLARE @message                    AS nvarchar(max);

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   SET @component = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      BEGIN
         -- --------------------------------------------------------------------------------
         -- Check @p_executionId
         -- --------------------------------------------------------------------------------
         IF (@p_executionId IS NULL)
            BEGIN
               SET @message = N'The parameter ''p_ExecutionId'' is NULL.';
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_state
         -- --------------------------------------------------------------------------------
         IF ([dbo].[fnIsNullOrEmpty](@p_state, 1) <> 0 )
            BEGIN
               SET @message = N'The parameter ''p_state'' is NULL or an empty string.';
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_success
         -- --------------------------------------------------------------------------------
         IF (@p_success IS NULL)
            BEGIN
               SET @message = N'The parameter ''p_success'' is NULL.';
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check combination of @p_success AND @p_success
         -- --------------------------------------------------------------------------------
         IF (@p_success = 0 AND @p_state IN (N'success')) OR (@p_success = 1 AND @p_state IN (N'processing', N'error'))
            BEGIN
               SET @message = CONCAT(N'Invalid state ''', @p_state, N''' for p_success = ''', CAST(@p_success AS nvarchar(100)), N'''.');
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check whether an execution log does exist in [LL].[Execution] with
         -- EXL_ID = @p_executionId
         -- --------------------------------------------------------------------------------
         SELECT
             @tempuid = [Id]
         FROM
            [LL].[Execution]
         WHERE
            [Id] = @p_executionId;

         IF (@tempuid IS NULL)
            BEGIN
               SET @message = N'A record with [Id] = ''' + CAST(@p_executionId AS nvarchar(max)) + N''' could not be found.';
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
      END;

      -- --------------------------------------------------------------------------------
      -- Update execution log in [LL].[Execution]
      -- --------------------------------------------------------------------------------
      UPDATE [LL].[Execution]
         SET
             [End]     = CASE WHEN @p_state IN (N'success', N'error') THEN GETUTCDATE() ELSE [End] END
            ,[State]   = @p_state
            ,[Success] = @p_success
      WHERE
         [ID] = @p_executionId;

      RETURN 0;
   END TRY
   BEGIN CATCH
      THROW;
   END CATCH;
END
-- [LL].[spUpdateExecution]

-- EXEC [LL].[spUpdateExecution] 1, @end, N'success', 1;
GO
/****** Object:  StoredProcedure [LL].[spUpdateTrace]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Updates the fields [State] and [Success] in [LL].[Trace] for
--              the row with [ID] = @p_traceId.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_traceId              AS int
--       ID of the row in [LL].[Trace], that is to be updated.
--   @p_description           AS nvarchar(max)
--       Additional description of the task in the calling object that will be logged
--    @p_action               AS nvarchar(max) = NULL
--       Specifiy any action that will be logged by this procedure call like Insert, Delete, Update, ...
--    @p_affectedRows         AS nvarchar(max) = NULL
--       Specifiy the number of rows/objects that were inserted, deleted, updated, ...
--    @p_state                AS nvarchar(100)
--       State of the current task (processing, success, error, warning)
--    @p_success              AS bit
--       Specifies the success state of the execution
--       0 = @p_state > processing, warning, error
--       1 = @p_state > success, warning
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spUpdateTrace]
    @p_traceId               AS int
   ,@p_description           AS nvarchar(max)
   ,@p_action                AS nvarchar(100) = NULL
   ,@p_affectedRows          AS int
   ,@p_state                 AS nvarchar(100)
   ,@p_success               AS bit
AS
BEGIN
   SET NOCOUNT ON;

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   DECLARE @component        AS nvarchar(128);
   DECLARE @tempuid          AS int;
   DECLARE @message          AS nvarchar(max);

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   SET @component = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      BEGIN
         -- --------------------------------------------------------------------------------
         -- Check @p_traceId
         -- --------------------------------------------------------------------------------
         IF (@p_traceId IS NULL)
            BEGIN
               EXEC [dbo].[spRaiseError] N'The parameter ''p_traceid'' is NULL.', @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check @p_success
         -- --------------------------------------------------------------------------------
         IF (@p_success IS NULL)
            BEGIN
               SET @message = 'The parameter ''p_success'' is NULL.';
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check combination of @p_success and @p_state
         -- --------------------------------------------------------------------------------
         IF (@p_success = 0 AND @p_state IN (N'success')) OR (@p_success = 1 AND @p_state IN (N'processing', N'error'))
            BEGIN
               SET @message = CONCAT(N'Invalid state ''', @p_state, N''' for p_success = ''', CAST(@p_success AS nvarchar(100)),'''.');
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
         -- --------------------------------------------------------------------------------
         -- Check whether an trace log does exist in [LL].[Trace] with
         -- [ID] = @p_traceId
         -- --------------------------------------------------------------------------------
         SELECT
             @tempuid = [Id]
         FROM
            [LL].[Trace]
         WHERE
            [Id] = @p_traceId;

         IF (@tempuid IS NULL)
            BEGIN
               SET @message = N'A record with [ID] = ''' + CAST(@p_traceId AS nvarchar(max)) + N''' could not be found.';
               EXEC [dbo].[spRaiseError] @message, @component;
               RETURN 1;
            END;
      END;

      -- --------------------------------------------------------------------------------
      -- Update trace log in [LL].[Trace]
      -- --------------------------------------------------------------------------------
      UPDATE [LL].[Trace]
         SET
             [Description]  = CASE WHEN (@p_description IS NULL OR DATALENGTH(@p_description) = 0) AND ([Description] IS NULL OR DATALENGTH([Description]) = 0) THEN NULL ELSE @p_description END
            ,[Action]       = @p_action
            ,[AffectedRows] = @p_affectedRows
            ,[State]        = @p_state
            ,[Success]      = @p_success
      WHERE
         [Id] = @p_traceId;

      RETURN 0;
   END TRY
   BEGIN CATCH
      THROW;
   END CATCH;
END;
-- [dbo].[spUpdateTrace]

-- EXEC [LL].[spUpdateTrace] 1, N'process successfully finished', N'Insert', 123, N'success', 1;
GO
/****** Object:  StoredProcedure [LL].[spUpdateTraceError]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Updates [LL].[Trace] with [State] = 'error' and [Success] = '0'.
--              Designed for usage in SSIS.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_traceId              AS int
--       ID of the row in [LL].[Trace], that is to be updated.
--   @p_description           AS nvarchar(max)
--       Additional description of the task in the calling object that will be logged
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spUpdateTraceError]
    @p_traceId               AS int
   ,@p_description           AS nvarchar(max)
AS
BEGIN
   SET NOCOUNT ON;

   EXEC [LL].[spUpdateTrace]
       @p_traceId
      ,@p_description
      ,NULL
      ,0
      ,'error'
      ,0;
END;
-- [LL].[spUpdateTraceError]

-- EXEC [LL].[spUpdateTraceError] 1, N'description';
GO
/****** Object:  StoredProcedure [LL].[spUpdateTraceSuccess]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Updates [LL].[Trace] with [State] = 'success' and [Success] = '1'
--              Designed for usage in SSIS.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_traceId              AS int
--       ID of the row in [LL].[Trace], that is to be updated.
--    @p_description           AS nvarchar(max)
--       Additional description of the task in the calling object that will be logged
--    @p_action               AS nvarchar(max) = NULL
--       Specifiy any action that will be logged by this procedure call like Insert, Delete, Update, ...
--    @p_affectedRows         AS nvarchar(max) = NULL
--       Specifiy the number of rows/objects that were inserted, deleted, updated, ...
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spUpdateTraceSuccess]
    @p_traceId               AS int
   ,@p_description           AS nvarchar(max)
   ,@p_action                AS nvarchar(100) = NULL
   ,@p_affectedRows          AS int
AS
BEGIN
   SET NOCOUNT ON;

   EXEC [LL].[spUpdateTrace]
       @p_traceId
      ,@p_description
      ,@p_action
      ,@p_affectedRows
      ,'success'
      ,1;
END;
-- [LL].[spUpdateTraceSuccess]

-- EXEC [LL].[spUpdateTraceSuccess] 1, 'description', 'Insert', 11;
GO
/****** Object:  StoredProcedure [LL].[spUpdateTraceWarning]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Author     : Marcus Belz
-- Create date: 01.01.2018
-- Description: Updates [LL].[Trace] with [State] = 'warning' and [Success] = '1'
--              Designed for usage in SSIS.
-- --------------------------------------------------------------------------------
-- Parameters :
--    @p_traceId              AS int
--       ID of the row in [LL].[Trace], that is to be updated.
--    @p_description          AS nvarchar(max)
--       Additional description of the task in the calling object that will be logged
--    @p_action               AS nvarchar(max) = NULL
--       Specifiy any action that will be logged by this procedure call like Insert, Delete, Update, ...
--    @p_affectedRows         AS nvarchar(max) = NULL
--       Specifiy the number of rows/objects that were inserted, deleted, updated, ...
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [LL].[spUpdateTraceWarning]
    @p_traceId               AS int
   ,@p_description           AS nvarchar(max)
   ,@p_action                AS nvarchar(100) = NULL
   ,@p_affectedRows          AS int
AS
BEGIN
   SET NOCOUNT ON;

   EXEC [LL].[spUpdateTrace]
       @p_traceId
      ,@p_description
      ,@p_action
      ,@p_affectedRows
      ,'warning'
      ,1;
END;
-- [LL].[spUpdateTraceWarning]

-- EXEC [LL].[spUpdateTraceWarning] 1, N'description', N'action', 1;
GO
/****** Object:  StoredProcedure [T2].[spDoSomething_1]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- --------------------------------------------------------------------------------
-- 02: Create [T2].[spDoSomething_1]
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [T2].[spDoSomething_1]
(   
    @p_executionId           AS int
)
AS
BEGIN
   SET NOCOUNT ON;   

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   -- Error Variables
   DECLARE @error_message    AS nvarchar(max);
   DECLARE @error_number     AS int;
   DECLARE @error_line       AS int;
   DECLARE @error_state      AS nvarchar(max);

   -- Logging Variables
   DECLARE @component        AS nvarchar(128);
   DECLARE @task             AS nvarchar(128);
   DECLARE @schema           AS nvarchar(128);
   DECLARE @table            AS nvarchar(128);

   DECLARE @source           AS nvarchar(5);
   DECLARE @step             AS nvarchar(max);
   DECLARE @entity           AS nvarchar(max);
   DECLARE @message          AS nvarchar(max);

   DECLARE @traceId          AS int; 
   DECLARE @componentId      AS int;

   DECLARE @description      AS nvarchar(max);
   DECLARE @affectedrows     AS int;
   DECLARE @action           AS varchar(100);
   DECLARE @state            AS varchar(100);
   DECLARE @success          AS int;

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   -- Logging
   SET @message          = NULL;
   SET @description      = NULL;
   SET @affectedrows     = 0;

   SET @component        = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);
   SET @source           = N'T-SQL';
   SET @entity           = N'[<SchemaName>].[<TableName>]';

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      BEGIN
         IF (@p_executionId IS NULL)
            BEGIN
               SET @message = N'The parameter ''p_executionId'' is NULL.';
               EXEC [dbo].[spRaiseError] @message,  @component;
               RETURN -1;
            END;
      END;

      -- --------------------------------------------------------------------------------
      -- Insert component log
      -- --------------------------------------------------------------------------------
      SET @step        = N'Do something';
      SET @description = '';
      EXEC [LL].[spInsertComponent] @p_executionId, @componentId OUTPUT, @source, @component, NULL, @entity, @step, @description;
      
      -- --------------------------------------------------------------------------------
      -- Insert data
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Insert data';
      SET @action      = 'insert';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      -- Insert here a SQL Statement that inserts data into a table

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;
   
      -- --------------------------------------------------------------------------------
      -- Update data
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Update data';
      SET @action      = 'update';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      -- Insert here a SQL Statement that updates data a table

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;

      -- --------------------------------------------------------------------------------
      -- Delete data      
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Delete data';
      SET @action      = 'delete';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      -- Insert here a SQL Statement that deletes data from a table

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;

      -- --------------------------------------------------------------------------------
      -- Update component log 
      -- --------------------------------------------------------------------------------
      EXEC [LL].[spUpdateComponentSuccess] @componentId, @description;

   END TRY
   BEGIN CATCH
      SET @error_message = ERROR_MESSAGE();
      SET @error_number  = ERROR_NUMBER();
      SET @error_line    = ERROR_LINE();
      SET @error_state   = ERROR_STATE();

      -- Write in Logging
      IF @p_executionId IS NOT NULL
         BEGIN
            EXEC [LL].[spInsertErrorException] @p_executionId, @componentId, @traceId, @source, @component, NULL, NULL, @step, @error_number, @error_message, @error_line, @error_state;

            IF @traceId IS NOT NULL     EXEC [LL].[spUpdateTraceError] @traceId, @description;
            IF @componentId IS NOT NULL EXEC [LL].[spUpdateComponentError] @componentId, @description;
         END;
      THROW;
   END CATCH; 
END
-- [T2].[spDoSomething_1]
GO
/****** Object:  StoredProcedure [T2].[spDoSomething_2]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- --------------------------------------------------------------------------------
-- 03: Create [T2].[spDoSomething_2]
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [T2].[spDoSomething_2]
(   
    @p_executionId           AS int
)
AS
BEGIN
   SET NOCOUNT ON;   

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   -- Error Variables
   DECLARE @error_message    AS nvarchar(max);
   DECLARE @error_number     AS int;
   DECLARE @error_line       AS int;
   DECLARE @error_state      AS nvarchar(max);

   -- Logging Variables
   DECLARE @component        AS nvarchar(128);
   DECLARE @task             AS nvarchar(128);
   DECLARE @schema           AS nvarchar(128);
   DECLARE @table            AS nvarchar(128);

   DECLARE @source           AS nvarchar(5);
   DECLARE @step             AS nvarchar(max);
   DECLARE @entity           AS nvarchar(max);
   DECLARE @message          AS nvarchar(max);

   DECLARE @traceId          AS int; 
   DECLARE @componentId      AS int;

   DECLARE @description      AS nvarchar(max);
   DECLARE @affectedrows     AS int;
   DECLARE @action           AS varchar(100);
   DECLARE @state            AS varchar(100);
   DECLARE @success          AS int;

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   -- Logging
   SET @message          = NULL;
   SET @description      = NULL;
   SET @affectedrows     = 0;

   SET @component        = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);
   SET @source           = N'T-SQL';
   SET @entity           = N'[<Multiple Schemas>].[<Multiple Tables>]';

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      BEGIN
         IF (@p_executionId IS NULL)
            BEGIN
               SET @message = N'The parameter ''p_executionId'' is NULL.';
               EXEC [dbo].[spRaiseError] @message,  @component;
               RETURN -1;
            END;
      END;

      -- --------------------------------------------------------------------------------
      -- Insert component log
      -- --------------------------------------------------------------------------------
      SET @step        = N'Execute Procedures';
      SET @description = '';
      EXEC [LL].[spInsertComponent] @p_executionId, @componentId OUTPUT, @source, @component, NULL, @entity, @step, @description;
      
      -- --------------------------------------------------------------------------------
      -- Execute procedure [T2].[spDoSomething_2_1]
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Execute [T2].[spDoSomething_2_1]';
      SET @action      = 'execute';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      EXEC [T2].[spDoSomething_2_1] @p_executionId;

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;
   
      -- --------------------------------------------------------------------------------
      -- Execute procedure [T2].[spDoSomething_2_2]
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Execute [T2].[spDoSomething_2_2]';
      SET @action      = 'execute';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      EXEC [T2].[spDoSomething_2_2] @p_executionId;

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;

      -- --------------------------------------------------------------------------------
      -- Update component log 
      -- --------------------------------------------------------------------------------
      EXEC [LL].[spUpdateComponentSuccess] @componentId, @description;

   END TRY
   BEGIN CATCH
      SET @error_message = ERROR_MESSAGE();
      SET @error_number  = ERROR_NUMBER();
      SET @error_line    = ERROR_LINE();
      SET @error_state   = ERROR_STATE();

      -- Write in Logging
      IF @p_executionId IS NOT NULL
         BEGIN
            EXEC [LL].[spInsertErrorException] @p_executionId, @componentId, @traceId, @source, @component, NULL, NULL, @step, @error_number, @error_message, @error_line, @error_state;

            IF @traceId IS NOT NULL     EXEC [LL].[spUpdateTraceError] @traceId, @description;
            IF @componentId IS NOT NULL EXEC [LL].[spUpdateComponentError] @componentId, @description;
         END;
      THROW;
   END CATCH; 
END
-- [T2].[spDoSomething_2]
GO
/****** Object:  StoredProcedure [T2].[spDoSomething_2_1]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- --------------------------------------------------------------------------------
-- 04: Create [T2].[spDoSomething_2_1]
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [T2].[spDoSomething_2_1]
(   
    @p_executionId           AS int
)
AS
BEGIN
   SET NOCOUNT ON;   

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   -- Error Variables
   DECLARE @error_message    AS nvarchar(max);
   DECLARE @error_number     AS int;
   DECLARE @error_line       AS int;
   DECLARE @error_state      AS nvarchar(max);

   -- Logging Variables
   DECLARE @component        AS nvarchar(128);
   DECLARE @task             AS nvarchar(128);
   DECLARE @schema           AS nvarchar(128);
   DECLARE @table            AS nvarchar(128);

   DECLARE @source           AS nvarchar(5);
   DECLARE @step             AS nvarchar(max);
   DECLARE @entity           AS nvarchar(max);
   DECLARE @message          AS nvarchar(max);

   DECLARE @traceId          AS int; 
   DECLARE @componentId      AS int;

   DECLARE @description      AS nvarchar(max);
   DECLARE @affectedrows     AS int;
   DECLARE @action           AS varchar(100);
   DECLARE @state            AS varchar(100);
   DECLARE @success          AS int;

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   -- Logging
   SET @message          = NULL;
   SET @description      = NULL;
   SET @affectedrows     = 0;

   SET @component        = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);
   SET @source           = N'T-SQL';
   SET @entity           = N'[<SchemaName>].[<TableName>]';

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      BEGIN
         IF (@p_executionId IS NULL)
            BEGIN
               SET @message = N'The parameter ''p_executionId'' is NULL.';
               EXEC [dbo].[spRaiseError] @message,  @component;
               RETURN -1;
            END;
      END;

      -- --------------------------------------------------------------------------------
      -- Insert component log
      -- --------------------------------------------------------------------------------
      SET @step        = N'Do something';
      SET @description = '';
      EXEC [LL].[spInsertComponent] @p_executionId, @componentId OUTPUT, @source, @component, NULL, @entity, @step, @description;
      
      -- --------------------------------------------------------------------------------
      -- Insert data
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Insert data';
      SET @action      = 'insert';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      -- Insert here a SQL Statement that inserts data into a table

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;
   
      -- --------------------------------------------------------------------------------
      -- Update data
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Update data';
      SET @action      = 'update';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      -- Insert here a SQL Statement that updates data a table

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;

      -- --------------------------------------------------------------------------------
      -- Delete data      
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Delete data';
      SET @action      = 'delete';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      -- Insert here a SQL Statement that deletes data from a table

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;

      -- --------------------------------------------------------------------------------
      -- Update component log 
      -- --------------------------------------------------------------------------------
      EXEC [LL].[spUpdateComponentSuccess] @componentId, @description;

   END TRY
   BEGIN CATCH
      SET @error_message = ERROR_MESSAGE();
      SET @error_number  = ERROR_NUMBER();
      SET @error_line    = ERROR_LINE();
      SET @error_state   = ERROR_STATE();

      -- Write in Logging
      IF @p_executionId IS NOT NULL
         BEGIN
            EXEC [LL].[spInsertErrorException] @p_executionId, @componentId, @traceId, @source, @component, NULL, NULL, @step, @error_number, @error_message, @error_line, @error_state;

            IF @traceId IS NOT NULL     EXEC [LL].[spUpdateTraceError] @traceId, @description;
            IF @componentId IS NOT NULL EXEC [LL].[spUpdateComponentError] @componentId, @description;
         END;
      THROW;
   END CATCH; 
END
-- [T2].[spDoSomething_2_1]
GO
/****** Object:  StoredProcedure [T2].[spDoSomething_2_2]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- --------------------------------------------------------------------------------
-- 05: Create [T2].[spDoSomething_2_2]
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [T2].[spDoSomething_2_2]
(   
    @p_executionId           AS int
)
AS
BEGIN
   SET NOCOUNT ON;   

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   -- Error Variables
   DECLARE @error_message    AS nvarchar(max);
   DECLARE @error_number     AS int;
   DECLARE @error_line       AS int;
   DECLARE @error_state      AS nvarchar(max);

   -- Logging Variables
   DECLARE @component        AS nvarchar(128);
   DECLARE @task             AS nvarchar(128);
   DECLARE @schema           AS nvarchar(128);
   DECLARE @table            AS nvarchar(128);

   DECLARE @source           AS nvarchar(5);
   DECLARE @step             AS nvarchar(max);
   DECLARE @entity           AS nvarchar(max);
   DECLARE @message          AS nvarchar(max);

   DECLARE @traceId          AS int; 
   DECLARE @componentId      AS int;

   DECLARE @description      AS nvarchar(max);
   DECLARE @affectedrows     AS int;
   DECLARE @action           AS varchar(100);
   DECLARE @state            AS varchar(100);
   DECLARE @success          AS int;

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   -- Logging
   SET @message          = NULL;
   SET @description      = NULL;
   SET @affectedrows     = 0;

   SET @component        = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);
   SET @source           = N'T-SQL';
   SET @entity           = N'[<SchemaName>].[<TableName>]';

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      BEGIN
         IF (@p_executionId IS NULL)
            BEGIN
               SET @message = N'The parameter ''p_executionId'' is NULL.';
               EXEC [dbo].[spRaiseError] @message,  @component;
               RETURN -1;
            END;
      END;

      -- --------------------------------------------------------------------------------
      -- Insert component log
      -- --------------------------------------------------------------------------------
      SET @step        = N'Do something';
      SET @description = '';
      EXEC [LL].[spInsertComponent] @p_executionId, @componentId OUTPUT, @source, @component, NULL, @entity, @step, @description;
      
      -- --------------------------------------------------------------------------------
      -- Insert data
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Insert data';
      SET @action      = 'insert';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      -- Insert here a SQL Statement that inserts data into a table

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;
   
      -- --------------------------------------------------------------------------------
      -- Update data
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Update data';
      SET @action      = 'update';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      -- Insert here a SQL Statement that updates data a table

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;

      -- --------------------------------------------------------------------------------
      -- Delete data      
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Delete data';
      SET @action      = 'delete';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @p_executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      -- Insert here a SQL Statement that deletes data from a table
      RAISERROR('Exception in [T2].[spDoSomething_2_2]', 15, 1);
      
      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;

      -- --------------------------------------------------------------------------------
      -- Update component log 
      -- --------------------------------------------------------------------------------
      EXEC [LL].[spUpdateComponentSuccess] @componentId, @description;

   END TRY
   BEGIN CATCH
      SET @error_message = ERROR_MESSAGE();
      SET @error_number  = ERROR_NUMBER();
      SET @error_line    = ERROR_LINE();
      SET @error_state   = ERROR_STATE();

      -- Write in Logging
      IF @p_executionId IS NOT NULL
         BEGIN
            EXEC [LL].[spInsertErrorException] @p_executionId, @componentId, @traceId, @source, @component, NULL, NULL, @step, @error_number, @error_message, @error_line, @error_state;

            IF @traceId IS NOT NULL     EXEC [LL].[spUpdateTraceError] @traceId, @description;
            IF @componentId IS NOT NULL EXEC [LL].[spUpdateComponentError] @componentId, @description;
         END;
      THROW;
   END CATCH; 
END
-- [T2].[spDoSomething_2_2]
GO
/****** Object:  StoredProcedure [T2].[spETLProcess]    Script Date: 17.02.2024 20:27:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- --------------------------------------------------------------------------------
-- Book
--    3.4 Example for logging an ETL process
--
-- Description
--   This script creates prcedures that simulate the executen of an ET process.
--   The entry point for the ETL proces is the procedure [T2].[spETLProcess]. This 
--   procedures executes other procedures in the following order:
--
--   [T2].[spETLProcess]
--        [T2].[spDoSomething_1]
--        [T2].[spDoSomething_2]
--             [T2].[spDoSomething_2_1]
--             [T2].[spDoSomething_2_2]
--
-- Note
--   [T2].[spDoSomething_2_2] raises an exception and causes the ETL process 
--   to be ended with the status error. 
--
-- Dependencies
--   This script must be executed in a database containing the SQL framwork.
--
-- Content
--
--   01: Create procedure [T2].[spETLProcess]
--   02: Create procedure [T2].[spDoSomething_1]
--   03: Create procedure [T2].[spDoSomething_2]
--   04: Create procedure [T2].[spDoSomething_2_1]
--   05: Create procedure [T2].[spDoSomething_2_2]
-- --------------------------------------------------------------------------------

-- --------------------------------------------------------------------------------
-- 01: Create [T2].[spETLProcess]
-- --------------------------------------------------------------------------------
CREATE PROCEDURE [T2].[spETLProcess]
AS
BEGIN
   SET NOCOUNT ON;   

   -- --------------------------------------------------------------------------------
   -- Declare variables
   -- --------------------------------------------------------------------------------
   -- Error Variables
   DECLARE @error_message    AS nvarchar(max);
   DECLARE @error_number     AS int;
   DECLARE @error_line       AS int;
   DECLARE @error_state      AS nvarchar(max);

   -- Logging Variables
   DECLARE @component        AS nvarchar(128);
   DECLARE @task             AS nvarchar(128);
   DECLARE @schema           AS nvarchar(128);
   DECLARE @table            AS nvarchar(128);

   DECLARE @source           AS nvarchar(5);
   DECLARE @step             AS nvarchar(max);
   DECLARE @entity           AS nvarchar(max);
   DECLARE @message          AS nvarchar(max);

   DECLARE @traceId          AS int; 
   DECLARE @componentId      AS int;
   DECLARE @executionId      AS int;

   DECLARE @description      AS nvarchar(max);
   DECLARE @affectedrows     AS int;
   DECLARE @action           AS varchar(100);
   DECLARE @state            AS varchar(100);
   DECLARE @success          AS int;

   -- --------------------------------------------------------------------------------
   -- Initialize variables
   -- --------------------------------------------------------------------------------
   -- Logging
   SET @message          = NULL;
   SET @description      = NULL;
   SET @affectedrows     = 0;

   SET @component        = OBJECT_SCHEMA_NAME(@@PROCID) + N'.' + OBJECT_NAME(@@PROCID);
   SET @source           = N'T-SQL';
   SET @entity           = N'[<Multiple Schemas>].[<Multiple Tables>]';

   -- --------------------------------------------------------------------------------
   -- Workload
   -- --------------------------------------------------------------------------------
   BEGIN TRY
      -- --------------------------------------------------------------------------------
      -- Check parameters
      -- --------------------------------------------------------------------------------
      EXEC [LL].[spInsertExecution] @executionId OUTPUT, N'ETL process', 123;

      -- --------------------------------------------------------------------------------
      -- Insert component log
      -- --------------------------------------------------------------------------------
      SET @step        = N'Orchestrate ETL process';
      SET @description = '';
      EXEC [LL].[spInsertComponent] @executionId, @componentId OUTPUT, @source, @component, NULL, @entity, @step, @description;
      
      -- --------------------------------------------------------------------------------
      -- Execute Procedure [T2].[spDoSomething_1]
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Execute [T2].[spDoSomething_1]';
      SET @action      = 'execute';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      EXEC [T2].[spDoSomething_1] @executionId;

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;

      -- --------------------------------------------------------------------------------
      -- Execute Procedure [T2].[spDoSomething_2]
      -- --------------------------------------------------------------------------------
      SET @task        = NULL;
      SET @step        = N'Execute [T2].[spDoSomething_2]';
      SET @action      = 'execute';
      SET @description = NULL; 
      SET @state       = 'processing';
      SET @success     = 0;
      EXEC [LL].[spInsertTrace] @executionId, @componentId, @traceId OUTPUT, @source, @component, @task, @entity, @step, @description, NULL, @action, NULL, @state, @success;

      EXEC [T2].[spDoSomething_2] @executionId;

      EXEC [LL].[spUpdateTraceSuccess] @traceId, @description, @action, @@ROWCOUNT;

      -- --------------------------------------------------------------------------------
      -- Execute another procedure 
      -- --------------------------------------------------------------------------------
      -- ...

      -- --------------------------------------------------------------------------------
      -- Update component log 
      -- --------------------------------------------------------------------------------
      EXEC [LL].[spUpdateComponentSuccess] @componentId, @description;

      -- --------------------------------------------------------------------------------
      -- Update execution log 
      -- --------------------------------------------------------------------------------
      SET @state       = 'success';
      SET @success     = 1;
      EXEC [LL].[spUpdateExecution] @executionId, @state, @success;

   END TRY
   BEGIN CATCH
      SET @error_message = ERROR_MESSAGE();
      SET @error_number  = ERROR_NUMBER();
      SET @error_line    = ERROR_LINE();
      SET @error_state   = ERROR_STATE();

      IF @executionId IS NOT NULL
         BEGIN
            EXEC [LL].[spInsertErrorException] @executionId, @componentId, @traceId, @source, @component, NULL, NULL, @step, @error_number, @error_message, @error_line, @error_state;

            IF @traceId IS NOT NULL     EXEC [LL].[spUpdateTraceError] @traceId, @description;
            IF @componentId IS NOT NULL EXEC [LL].[spUpdateComponentError] @componentId, @description;

            SET @state       = 'error';
            SET @success     = 0;
            EXEC [LL].[spUpdateExecution] @executionId, @state, @success;
         END;
   END CATCH; 
END
-- [T2].[spETLProcess]
GO
